/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.utils;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Properties;
import net.skinsrestorer.bukkit.SkinsRestorer;
import net.skinsrestorer.shadow.spiget.ResourceInfo;
import net.skinsrestorer.shadow.spiget.download.DownloadCallback;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class UpdateDownloader {
    protected final SkinsRestorer plugin;
    protected DownloadFailReason failReason;

    public boolean downloadUpdate() {
        boolean allowExternalDownload;
        ResourceInfo latestResourceInfo = this.plugin.getUpdateChecker().getLatestResourceInfo();
        if (latestResourceInfo == null) {
            this.failReason = DownloadFailReason.NOT_CHECKED;
            return false;
        }
        if (!this.plugin.getUpdateChecker().isVersionNewer(this.plugin.getUpdateChecker().getCurrentVersion(), latestResourceInfo.latestVersion.name)) {
            this.failReason = DownloadFailReason.NO_UPDATE;
            return false;
        }
        if (latestResourceInfo.external) {
            this.failReason = DownloadFailReason.NO_DOWNLOAD;
            return false;
        }
        File pluginFile = this.getPluginFile();
        if (pluginFile == null) {
            this.failReason = DownloadFailReason.NO_PLUGIN_FILE;
            return false;
        }
        File updateFolder = Bukkit.getUpdateFolderFile();
        if (!updateFolder.exists() && !updateFolder.mkdirs()) {
            this.failReason = DownloadFailReason.NO_UPDATE_FOLDER;
            return false;
        }
        final File updateFile = new File(updateFolder, pluginFile.getName());
        Properties properties = this.getUpdaterProperties();
        boolean bl = allowExternalDownload = properties != null && properties.containsKey("externalDownloads") && Boolean.parseBoolean(properties.getProperty("externalDownloads"));
        if (!allowExternalDownload && latestResourceInfo.external) {
            this.failReason = DownloadFailReason.EXTERNAL_DISALLOWED;
            return false;
        }
        this.plugin.getSrLogger().info("[SpigetUpdate] Downloading update...");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, net.skinsrestorer.shadow.spiget.download.UpdateDownloader.downloadAsync(latestResourceInfo, updateFile, this.plugin.getUpdateChecker().getUserAgent(), new DownloadCallback(){

            @Override
            public void finished() {
                UpdateDownloader.this.plugin.getSrLogger().info("[SpigetUpdate] Update saved as " + updateFile.getPath());
            }

            @Override
            public void error(Exception exception) {
                UpdateDownloader.this.plugin.getSrLogger().warning("[SpigetUpdate] Could not download update", exception);
            }
        }));
        return true;
    }

    public Properties getUpdaterProperties() {
        File file = new File(Bukkit.getUpdateFolderFile(), "spiget.properties");
        Properties properties = new Properties();
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    return null;
                }
                properties.setProperty("externalDownloads", "false");
                try (FileWriter write = new FileWriter(file);){
                    properties.store(write, "Configuration for the Spiget auto-updater. https://spiget.org | https://github.com/InventivetalentDev/SpigetUpdater\nUse 'externalDownloads' if you want to auto-download resources hosted on external sites\n");
                }
            }
            catch (Exception ignored) {
                return null;
            }
        }
        try (FileReader reader = new FileReader(file);){
            properties.load(reader);
        }
        catch (IOException e) {
            return null;
        }
        return properties;
    }

    public File getPluginFile() {
        if (this.plugin == null) {
            return null;
        }
        try {
            Method method = JavaPlugin.class.getDeclaredMethod("getFile", new Class[0]);
            method.setAccessible(true);
            return (File)method.invoke((Object)this.plugin, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Could not get plugin file", e);
        }
    }

    public UpdateDownloader(SkinsRestorer plugin) {
        this.plugin = plugin;
    }

    public DownloadFailReason getFailReason() {
        return this.failReason;
    }

    public static enum DownloadFailReason {
        NOT_CHECKED,
        NO_UPDATE,
        NO_DOWNLOAD,
        NO_PLUGIN_FILE,
        NO_UPDATE_FOLDER,
        EXTERNAL_DISALLOWED;

    }
}

